Documentation [DOC]
    1. Addresses and Info
ASM [ASM]
    ovl_file_choose (32)
        1. Hero Mode Files
        2. Navigate with D-Pad
        3. 8 Hearts Per Row
        4. New File Select Screen Layout
    code (28)
        1. Create Hero Mode Files
Tables [TBL]
    ovl_file_choose (32)
        1. New File Select Screen Layout
    global
        1. Setup default file data
    
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------
Documentation [DOC]
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------

music (http://wiki.spinout182.com/w/Zelda_64:_OoT_Music_Values)
803FDD78 Branch to Stage Select
8022EA1C filenames

802229E0 Current Cursor Color Type
8022EA88 background color
8022EAC0 Cursor Color (9B FF FF by default)
8022EA58 currently selected file
8022EA5E current menu (0x4 = copy which file, 0x15 = erase which file, 0x2 = main)
8022EAE0 menu X position
803FC2A0 NOP Make filenames grey
803FC2B0 always branch Make filename grey when choosen

for extended RAM memory
0xB415B0 -> 3C188044 to 3C188074
0xB33C5C -> 3C05001D to 3C05004D



0x803F9F08 #Title X Position
0x803F9F18 #Title X Position

0x803FA964 #Y Position of 2nd Row
0x803FA96C #X Position of 2nd Row
0x803FA988 #Left margin for hearts

0x803F5058
0x803F4D68 #Number of letters in file name during file select
0x803FFC4C #File select name X position
0x803FFC64 #File select name Y position
0x803FFBA4 #File select letter position table
0x803FFA50 #File select letter table
0x803FFC24 #"Name?" Texture
0x803FFC30 #Backspace button texture
0x803FFC48 #Backspace button width
0x803F4CFC #number of name select buttons

0x803FA5A0 #
0x803FA71C #Number of objects that are file name letters
0x803FA7F8 #Number of objects that are death counter digits
0x803FA990 #Number of objects that are hearts
0x803FAA04 #Number of objects that are stones/medallions
0x803FAAA4 #Number of files
0x803FAABC #Lower 3 buttons X Position
0x803FAB2C #Number of objects that are buttons
0x803FB4A8 #Number of stones/medallions that are stones
0x803FB688 #Number of stones/medallions that should be displayed
0x803FAC80 #Branch if a file is chosen

0x803FCD84 #jal to function that does everything above
0x803FCD98 #Branch if in file creation

0x802117F0 #File Name Position and Size data
0x8022EA84 #Current title
0x8022EAC2 #Name Select Cursor Color
0x8022EAE4 #File Select Rotation
0x8022EA8E #"Name?" Alpha
0x8022EABC #Name Select Name Panel Alpha

0x803FFC4C #Name Select Name Panel X Offset
0x803FFC4E #Name Select Name Letter 1 X Offset

#Useful functions
0x803F568C #Name Select Letters
0x803F5694 #Name Select Buttons & Title
0x803FCD7C #Print Background

#Useful commands
0x803F45D8 #Name Select Letters Y Offset
0x803F45F8 #Name Select Letters X Offset
0x803F4600 #Name Select Letters Height
0x803F4650 #Name Select Letters Width
0x803F4694 #Name Select Letters Per Row
0x803F467C #Name Select Letters Horizontal Margin
0x803F4870 #Name Select Letter Vertical Margin
0x803F4874 #Name Select Letter Rows
0x803F4DE4 #Name Select File Name Letter Width
0x803F4EAC #Name Select File Name Letter Height
0x803F5144 #Name Select File Name Panel Alpha
0x803F5954 #Name Select Letter Cursor X Offset
0x803F59A4 #Name Select Letter Cursor Y Offset
0x803F59D4 #Name Select Letter Cursor Height
0x803FF210 #Name Select Name? object
0x803F492C #get name? alpha




0x803F9C6C #function start
0x803F9F00 #Title Y Position
0x803F9F2C #File Buttons Y Offset
0x803F9F34 #Title Width
0x803F9F6C #Title Height
0x803F9FA8 #File Background X Offset
0x803FA03C #File Content Y Offset
0x803FA068 #File Content Height
0x803FA0FC #File Name Object Width
0x803FA100 #File Buttons X Offset
0x803FA10C #File Name X Offset
0x803FA11C #File Connection X Offset
0x803FA160 #File Button Width
0x803FA1A8 #Some kind of File Button Width
0x803FA1B4 #Some kind of File Button Height
0x803FA210 #File Name Object Width
0x803FA260 #File Name Object Height
0x803FA3F4 #File Connection Width
0x803FA43C #File Connection Width
0x803FA4E0 #File Vertical Margin
0x803FA578 #Hearts per Row
0x803FA6A8 #File Names Y Offset
0x803FA6C0 #File Names X Offset
0x803FA790 #File objects Y Offset
0x803FA798 #Death Counter X Offset
0x803FA8B8 #Hearts Row 1 X Offset
0x803FA8FC #Hearts Width
0x803FA940 #Hearts Height
0x803FA964 #Hearts Row 2 Y Offset
0x803FA96C #Hearts Row 2 X Offset
0x803FA988 #Hearts Horizontal Margin
0x803FA9A0 #Stones & Medallions Y Offset
0x803FA9A8 #Stones & Medallions X Offset
0x803FA9E4 #Stones & Medallions Horizontal Margin
0x803FAA0C #Stones & Medallions Width
0x803FAA54 #Stones & Medallions Height
0x803FAAB4 #Lower Buttons Y Offset
0x803FAB14 #Lower Buttons Width
0x803FAB5C #Lower Buttons Vertical Margin
0x803FAB7C #Lower Buttons Height
0x803FABF4 #Options Button Width
0x803FAC18 #Options Button Y Offset
0x803FAC44 #Options Button Height
0x803FAD54 #Cursor X Offset
0x803FBF8C #???
0x803FD694 #Lower Buttons Y Offset when selecting file

0x803F4A8C #Start offset to read name select button data
0x803F4CFC #Number of buttons in name select
0x8022EAF0 #Currently Selected Button in name select
0x803F68E8 #Which button to move to when moving past END
0x803F6888 #How many buttons to skip past to the left

0x003FFC34 #Name select button textures
0x803FFC44 #Name select button data

0x001Bbe4C #name select name panel data


0x803FF2D0 #3rd button cursor position

0x8022EA66 CURRENTLY SELECTED FILE
0x8022EAAC FILE CONTENT ALPHA

0x803FFAE0 #Copy/Erase Menu Button Y Offset Table
    File 1
    File 2
    File 3
    Yes Button
    Quit Button
    ?
    ?
    ?
    ?
    ?
    ?
    ?
    ?
    ?
    ...
    

    
0x803FFDB8 #File Content Last BG Tile Texture Width
0x803FFE78 #Death Counter Position & size
0x803FFB9C #Name Select Name X Offset
0x803FFBA4 #Name Select Letter X Offset Table


802120E4 Screen Height
802120EC SCREEN WIDTH

800AA2B4 applies screen height
800AA2B8 applies screen width

803FFDD8 main menu button press check code
803FFDE0 copy button press check code

804000A8 all other button press check
804000AC file select button press check


803F8F0C this runs when you press erase in main menu
    $sp 80168408
803FD89C this runs when you click on return when a file is selected.
    it should return to 803FE008
    80168410 should work?
803F3260 this runs when you click to delete a file.
    $sp 80168410
    t0  8022A020

803F8BA8 branch if start is pressed
803F8BC0 branch if A isn't pressed
803F8BE4 branch if not pressing a File button
803F8E7C code to check for buttons that are not file buttons starts here
803F8EE4 branch if not Copy button
803F8F08 branch if not Erase button

803F8FCC branch here when no button is pressed

801B4940 file 1 name obj
801C6A08 file content obj
obj texture width
    0x1C
        (((((((Width<<0x1)>>0x3)+0x07FF)/((Width<<0x1)>>0x3))&0x0FFF)|0x07000000)|((0x07FF&0x0FFF)<<0xC)).toString(16)
    0x28
        (((((Width<<1)+0x0007)>>3)&0x01FF)<<0x9).toString(16)
    0x34
        (((((Width-1)<<2)&0x0FFF)<<0xC)|0x00DC).toString(16)


----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------
ASM [ASM]
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------

#_____________________________________________________________
#Hero Mode Files
#This will make it so that you can create two different file
#types by pressing the backspace button during name selection.
#The theme of the file select will change depending on
#currently selected file type.
#Hero Mode uses the debug file.
#_____________________________________________________________
#t3 = Current File in loop (1 indexed)
#t8 = File Mode (1 = Disk)
#t6, t7, t8, t9

#include "mips.h"

.set        noreorder
.set        noat

.text

.org 0x803FBFFC
    lw      a2, 0x02C0(t1)      #Already there
    lui     t9, 0x8023          #t9 = 0x80230000
    lhu     t6, -0x15A8(t9)     #t6 = Currently selected file
    addiu   t6, t6, 0x0001      #t6 = Currently selected file + 0x1
    bne     t6, t3, end         #Branch if it is currently NOT looping through selected file
    lhu     t6, -0x15A2(t9)     #t6 = Current Menu
    slti    t7, t6, 0x0003      #t7 is set if you're in main menu
    bne     t7, $zero, start    #Continue if you're in main menu
    addiu   t7, $zero, 0x0000   #Set background color offset to 0 (default)
    addiu   t7, $zero, 0x0004   #t7 = 0x0004
    beq     t6, t7, start       #Continue if you're in copy which file
    addiu   t7, $zero, 0x0006   #Set background color offset to 6 (yellow)
    addiu   t7, $zero, 0x0015   #t7 = 0x0015
    bne     t6, t7, end         #End if you're not in erase which file
    addiu   t7, $zero, 0x0003   #Set background color offset to 3 (red)
    start:
    lui     t6, 0x8040          #t6 = 0x80400000
    addu    t6, t6, t7          #t6 = 0x80400000 + Color offset
    bne     t8, $zero, hero     #Branch Likely if hero mode
    lui     t8, 0x8012          #t8 = 0x80120000
    addiu   t7, $zero, 0x0003   #t7 = 0x03
    sb      t7, -0x034E(t8)     #Set skybox to 0x3
    addiu   t7, $zero, 0x009B   #t7 = 0x9B
    sh      t7, -0x153E(t9)     #Cursor Red = t7
    addiu   t7, $zero, 0xFFFF   #t7 = 0xFFFFFFFF
    beq     $zero, $zero, skip       
    sw      t7, -0x153C(t9)     #Cursor Green & Blue = t7
    hero:
    addiu   t7, $zero, 0x0007   #t7 = 0x07
    sb      t7, -0x034E(t8)     #Set skybox to 0x7
    addiu   t7, $zero, 0x00F0   #t7 = 0xF0
    sh      t7, -0x153E(t9)     #Cursor Red = t7
    sh      t7, -0x153C(t9)     #Cursor Green = t7
    addiu   t7, $zero, 0x00D0   #t7 = 0xD0
    sh      t7, -0x153A(t9)     #Cursor Blue = t7
    skip:
#    lbu     t7, -0x0244(t6)     #t7 = Red
#    sh      t7, -0x1578(t9)     #Background Red = t7
#    lbu     t7, -0x0243(t6)     #t7 = Green
#    sh      t7, -0x1576(t9)     #Background Green = t7
#    lbu     t7, -0x0242(t6)     #t7 = Blue
#    sh      t7, -0x1574(t9)     #Background Blue = t7
    end:
    .=.+(42*0x4)                #NOP the next 42 commands

    
.org 0x803FC248
    j       0x003FC26C          #remove disk attachment
    
.org 0x803FC2A0
    j       0x003FC2B8          #make file name color normal
    
.org 0x803F8DC4
    NOP                         #Make file selectable

#------------------------------
#File Creation 
#------------------------------

.org 0x803F614C
    bnel    t7, $zero, setColor #Branch to color update function instead
    
#Set backspace to swap file type
.org 0x803F616C
    lh      t7, 0x4A48(t0)      #t7 = File Type
    beql    t7, $zero, continue #If file type is normal, set to hero mode
    addiu   t7, $zero, 0x0001   #Set file type to hero mode
    addu    t7, $zero, $zero    #Set file type to normal mode
    continue:
    j       0x003F6494          #Continue
    sh      t7, 0x4A48(t0)      #Store file type
    setColor:
    lui     t9, 0x8023          #t9 = 0x80230000
    lui     t6, 0x8040          #t6 = 0x80400000
    lh      t7, 0x4A48(t0)      #t7 = File Type
    bne     t7, $zero, heroColor#Branch if file type is Hero Mode
    addiu   t7, $zero, 0x0003   #t7 = 0x03
    sb      t7, 0x0392(s3)      #Set skybox to 0x3
    addiu   t7, $zero, 0x009B   #t7 = 0x9B
    sh      t7, -0x153E(t9)     #Cursor Red = t7
    addiu   t7, $zero, 0xFFFF   #t7 = 0xFFFFFFFF
    sw      t7, -0x153C(t9)     #Cursor Green & Blue = t7
    beq     $zero, $zero, end      
    addiu   t7, $zero, 0x3480
    heroColor:
    addiu   t7, $zero, 0x0007   #t7 = 0x07
    sb      t7, 0x0392(s3)      #Set skybox to 0x7
    addiu   t7, $zero, 0x00F0   #t7 = 0xF0
    sh      t7, -0x153E(t9)     #Cursor Red = t7
    sh      t7, -0x153C(t9)     #Cursor Green = t7
    addiu   t7, $zero, 0x00D0   #t7 = 0xD0
    sh      t7, -0x153A(t9)     #Cursor Blue = t7
    addiu   t7, $zero, 0x3800
    end:
    sh      t7, -0x03DA(t6)     #Change mode text
    #lbu     t7, -0x0244(t6)     #t7 = Red
    #sh      t7, -0x1578(t9)     #Background Red = t7
    #lbu     t7, -0x0243(t6)     #t7 = Green
    #sh      t7, -0x1576(t9)     #Background Green = t7
    #lbu     t7, -0x0242(t6)     #t7 = Blue
    #sh      t7, -0x1574(t9)     #Background Blue = t7
    .=.+(6*0x4)                 #NOP the next 6 commands
    j       0x003F6494          #Continue
    NOP
    
.org 0x803F6694
    sh      $zero, 0x4A48(a1)   #Reset File Type when entering File Creation
    
.org 0x803FE7C8
    lui     $at, 0xFFFF         #A-Decide*B-Cancel Red & Green
.org 0x803FE7DC
    ori     $at, $at, 0xFF00    #A-Decide*B-Cancel Blue

#File button color read value
.org 0x803FBDBC
    lbu     t9, 0x0009(a0)      #Change halfword to byte
.org 0x803FBDC8
    lbu     t9, 0x000A(a0)      #Change halfword to byte, change offset to 1
.org 0x803FBDD8
    lbu     t8, 0x000B(a0)      #Change halfword to byte, change offset to 2
.org 0x803FBEF8
    lbu     t7, 0x0009(a0)      #Change halfword to byte
.org 0x803FBF04
    lbu     t7, 0x000A(a0)      #Change halfword to byte, change offset to 1
.org 0x803FBF14
    lbu     t6, 0x000B(a0)      #Change halfword to byte, change offset to 2
.org 0x803FBD20
    addiu   s0, $zero, 0x0003   #Change distance to 3
    
#_____________________________________________________________
#Navigate with D-Pad
#This will make it so that you can use the D-Pad to navigate
#in the file select menues.
#_____________________________________________________________
#801665C0 buttons pressed (sub)
#80212034 buttons pressed (real)
#
#803FDD78 Branch to Stage Select
#8022EA1C filenames
#803FFDBC 0064 0096 00FF (Default color)
#803FFDC2 00F0 00E0 0080 (Disabled color)
#802229E0 Current Cursor Color Type
#8022EA88 background color
#8022EAC0 Cursor Color (9B FF FF by default)
#8022EA58 currently selected file
#8022EA5E current menu (0x4 = copy which file, 0x15 = erase which file, 0x2 = main)
#803FC2A0 NOP Make filenames grey
#803FC2B0 always branch Make filename grey when choosen
#
#8022EADA analog-stick X (halfword)
#8022EADC analog-stick Y (halfword)
#
#803FE4DC write analog-stick Y

#include "mips.h"

.set        noreorder
.set        noat

.text


.org 0x803FE4B8
    addiu   v0, s0, 0x0014
    lb      v1, 0x0014(v0)
    lb      t6, 0x0015(v0)
    lw      t0, 0x008C($sp)
    lb      a1, 0x0000(v0)      #a1 = D-Pad buttons pressed
    NOP
    NOP
    j       dPad               #
    NOP
    .global dPadReturn
    dPadReturn:
    lui     $at, 0x0002
    addu    $at, $at, s0
    addiu   a1, $at, 0x8000     #a1 = 0x8022A020
    sh      v1, -0x3546($at)
    sh      t6, -0x3544($at)

#a1 = Pressed D-Pad Buttons
#0x003C = Up
#0xFFC4 = Down
#0x003C = Right
#0xFFC4 = Left
#0x1 = right
#0x2 = left
#0x4 = down
#0x8 = up
#v1 = X
#t6 = Y
#Can use t7, $at
.org 0x804000C0
    .equ upRight,   0x003C
    .equ downLeft,  0xFFC4
    .equ right,     0x1
    .equ left,      0x2
    .equ down,      0x3
    .equ up,        0x4
    .global dPad
    dPad:
    andi    t7, a1, right       #t7 = Right is Pressed
    bnel    t7, $zero, .+8      #Branch likely if right is pressed
    addiu   v1, $zero, upRight  #
    andi    t7, a1, left        #t7 = Left is Pressed
    bnel    t7, $zero, .+8      #Branch likely if left is pressed
    addiu   v1, $zero, downLeft #
    andi    t7, a1, down        #t7 = Down is Pressed
    bnel    t7, $zero, .+8      #Branch likely if down is pressed
    addiu   t6, $zero, downLeft #
    andi    t7, a1, up          #t7 = Up is Pressed
    bnel    t7, $zero, .+8      #Branch likely if up is pressed
    addiu   t6, $zero, upRight  #
    j       dPadReturn          #Return
    NOP

#_____________________________________________________________
#8 Hearts Per Row
#This will make it so that there are 8 hearts per row rather
#than 10.
#_____________________________________________________________

#include "mips.h"

.set        noreorder
.set        noat

.text


.org 0x803FA578
    addiu   s4, $zero, 0x0007

#_____________________________________________________________
#New File Select Screen Layout
#This will redesign the file select menu.
#_____________________________________________________________
#The File Button is currently unused
#The File "Connection" is currently unused
#The File Content Container serves as the files background
#
#0x8022EA5A currently select button after selecting file
#0x8022EA66 currently selected file
#0x8022EA74 file Y offset
#0x8022EA94 file button alpha
#0x8022EAA6 file connection alpha
#0x8022EAAC file container alpha
#0x8022EAB2 Copy button alpha
#0x8022EAB4 Erase button alpha
#0x8022EAB6 Start button alpha
#0x8022EAB8 Return button alpha

#------------------------------
#START
#------------------------------
#802117F0 offsets?!

#include "mips.h"

.set        noreorder
.set        noat

.text

.org 0x803FC3BC
    addu    t9, $zero, $zero            #Hide Erase & Copy Button permanently

.org 0x803FC720
    addu    t7, $zero, $zero            #Hide Options Button permanently
    
.org 0x803FB50C
    lh      t3, 0x4A74(t8)      #Make stones & medallion alpha read from File button alpha instead

.org 0x803FB17C
    lh      t7, 0x4A74(t0)      #Make death counter read from File button alpha instead

.org 0x803FB17C
    addiu   t7, $zero, 0x0000       #Make death counter always invisible
    
.org 0x803FB2E0 
    lh      t8, 0x4A74(t6)      #Make hearts read from File button alpha instead

.org 0x803FBA74
    lh      t6, 0xCA74(t6)      #Make file container read from File button alpha instead

.org 0x803FBD80
    addiu   t7, $zero, 0x0000       #Make it so that file name panels NEVER appear
    
.org 0x803FBEF4
    addiu   t8, $zero, 0x0000       #Make it so that file name panels NEVER appear
    
.org 0x803FC138
    addiu   t6, $zero, 0x0000       #Make it so that file connections NEVER appear

.org 0x803FAD54
    addiu   v1, v1, 0xFFF5      #Cursor X Offset

.org 0x803FECB8
    addiu   t6, $zero, 0x0028       #File content Y offset
    
.org 0x803FECCC
    addiu   t8, $zero, 0x0000       #File name X offset
    
.org 0x803FB114
    beq     $zero, $zero, 0x803FB128    #Always display content of all files

.org 0x803FA4E0
    addiu   $ra, $ra, 0xFFD8        #Files vertical margin
    
.org 0x803FA100
    addiu   t0, t0, 0xFF9       #File Buttons X Offset
    
.org 0x803F9F2C
    addiu   $ra, $zero, 0x0039      #File Buttons Y Offset
    
.org 0x803FA03C
    addiu   v1, v1, 0x0039      #File Container Y Offset

.org 0x803FA790
    addiu   t1, t1, 0x0005      #File content Y Offset relative to name
    
.org 0x803F9FA8
    addiu   t0, t0, 0xFFF9      #File Container X Offset

.org 0x803FA6A8
    addiu   a3, t1, 0x0005      #File Name Y Offset
    
.org 0x803FA6C0
    addiu   v1, v1, 0x0012      #File Name X Offset
    
.org 0x803FA578
    addiu   s4, $zero, 0x0007       #Hearts per row

.org 0x803FA8B8
    addiu   t0, t0, 0x0074      #Heart row 1 X Offset
    
.org 0x803FA96C
    addiu   t0, t0, 0x006B      #Hearts row 2 X Offset
    
.org 0x803FAAB4
    addiu   $ra, $zero, 0xFFE1      #Lower buttons Y Offset
    
.org 0x803FD694
    addiu   t3, $zero, 0x0000       #Lower buttons Y offset when selecting a file
    
.org 0x803F9F00
    addiu   t6, $zero, 0x004C       #Title Y Position

.org 0x803F316C
    NOP                         #Do not change cursor position when opening erase menu

.org 0x803F31E8
    NOP                         #Do not change cursor position when closing erase menu
    
.org 0x803F1518
    NOP                         #Do not change cursor position when opening copy menu

.org 0x803F15A0
    NOP                         #Do not change cursor position when closing copy menu
    
.org 0x803F3D2C
    lhu     t7, 0x4A46(v0)      #When canceling file erase set cursor to selected file instead of return button
    
.org 0x803F207C
    lhu     t8, 0x4A46(t1)      #When canceling copy which file set cursor to selected file instead of return button
    
.org 0x803F1AA8
    slti    t8, t9, 0x0001      #When selecting a file to copy, set cursor to file 2 if file 1 is selected, otherwise set it to file 1.
    
.org 0x803F907C
    slti    $at, t5, 0x0003     #Limit cursor movement in main screen to 3 buttons.
    
.org 0x803F9058
    addiu   t7, $zero, 0x0002       #Go to button 3 when reaching -1 on main screen

.org 0x803F3424
    slti    $at, v1, 0x0003     #Limit cursor movement in erase screen to 3 buttons.
    
.org 0x803F33C4
    addiu   t1, $zero, 0x0002       #Go to button 3 when reaching -1 on erase screen

.org 0x803F17C8
    slti    $at, v1, 0x0003     #Limit cursor movement in copy screen to 3 buttons.
    
.org 0x803F1768
    addiu   t1, $zero, 0x0002       #Go to button 3 when reaching -1 on copy screen

.org 0x803F1DB8
    slti    $at, v1, 0x0003     #Limit cursor movement in copy to which file screen to 3 buttons.
    
.org 0x803F1D24
    addiu   t1, $zero, 0x0002       #Go to button 3 when reaching -1 on copy to which file screen

.org 0x803FC548
    addu    t8, s3, $at         #Some swapped registers so that t8 can be used down below
.org 0x803FC550
    addu    a1, t8, t7          #Some swapped registers so that t8 can be used down below
.org 0x803FC568
    lh      t8, 0x4A96(t8)      #Make Start and Return Button read from Start Button alpha

.org 0x803F3E28
    NOP                         #Prevent the file container from "dropping" and moving when deleting the file
.org 0x803F41FC
    NOP                         #Prevent the file container from reseting position after dropping when deleting the file

#801CF9F0 file button object
#801CF630 file container object
#File container texture width
.org 0x803F9F24
    addiu   t4, $zero, 0x0500       #Change file container texture height to 40px
.org 0x803FA068
    addiu   v1, v1, 0xFFD8      #Change file container object height to 40px
    
#Replaces the RAM copy function call that sets default filename in file creation
.org 0x803F8D8C
    addu    a0, a0, $at
    lui     a1, 0x3E3E
    addiu   a1, a1, 0x3E3E
    sw      a1, 0x0000(a0)
    sw      a1, 0x0004(a0)
    
#803F2938 #it doesn't jump here when it breaks
#8022EA70 object Y positions
#8022EA58 cursor position
#8022EAB8 return button alpha
#8022EA66 CURRENTLY SELECTED FILE
#803FFDBC Color RAM location
#8022EA48 File type RAM location

.org 0x803FBA58
    j       0x00400100
.org 0x80400100
    lw      v1, 0x004C($sp)
    addu    t6, v1, t7
    lbu     t6, 0x4A28(t6)      #t6 = File Type
    addiu   v1, t5, 0x000C      #v1 = address to hero mode color
    beql    t6, $zero, .+8      #Branch to next instruction
    addiu   v1, t5, 0x0009      #v1 = address to default color
    j       0x003FBA60
    NOP
.org 0x803FBA78
    lbu     t8, 0x000C(v1)      #
.org 0x803FBA88
    lbu     t8, 0x000D(v1)      #
.org 0x803FBA9C
    lbu     t9, 0x000E(v1)      #

.org 0x803F9EE8
    addu    t6, t7, a0          #Rewrite to gain one command
    bnez    $at, 0x803F9CC4     #Move command one step up
    sb      v1, 0x000C(t6)      #Move command one step up
    lh      v1, 0x4AC0(a2)      #Move command one step up
    addiu   v1, v1, 0x0020      #Increase Title X Position by 20
    
.org 0x803FA018
    sll     t9, a1, 0x0001      #t9 = Current File ID multiplied by 2.
    addu    t9, a2, t9          #t9 = 0x8022A020+(FileID*2)
.org 0x803FA040
    lh      t9, 0x4A52(t9)      #t9 = File Y offset modifier
    addu    v1, v1, t9          #add File Y offset modifier to file container Y offset


#Make it so that the file containers are aligned with the file content
.org 0x803FA048
    beq     $zero, $zero, cYPosHook
    addu    t9, t8, a0
    cYPosCont:
.org 0x80400130
cYPosHook:
    lhu     t6, 0xF7D0(s0)  #t6 = File Content Y distance
    mult    t6, a1          #t6 = File Content Y distance * current file
    mflo    t6
    sub     t6, $zero, t6
    addu    v1, v1, t6      #
    beq     $zero, $zero, cYPosCont
    sh      v1, 0x0012(t9)

.org 0x803FA034
    addiu v1, $zero, 0x0000 #Do not read from the container offset  
    
#------------------------------
#Help Text
#------------------------------
# 803FE844 sets the bottom text texture
# 804000B0 Help texture table

#Use Help Text 2 if you're in main menu, otherwise use Text 1
.org 0x803FE7F8
    lhu     t3, 0x4A3E(a1)      #t3 = Current Menu
    sw      $zero, 0x0004(v0)
    sw      t8, 0x0000(v0)
    addiu   v0, v0, 0x0008      
    lhu     t4, 0x4A3C(a1)      #t3 = Main Menu State (1 = Select File, 2 = File Selected)
    addu    t3, t4, t3          #t3 = Current Menu
.org 0x803FE824
    slti    t3, t3, 0x0004      #t4 is set if you're in main menu

#------------------------------
#Erase & Copy
#------------------------------
#2000 = Z
#0010 = R

.org 0x803F8BC0
    lui     $at, 0x0001
    ori     $at, $at, 0x8000
    addu    v1, s0, $at
    bnez    t9, 0x803F8E7C      #Branch to check for Z & R buttons if Start or A isn't pressed
    NOP
    
.org 0x803F8EB8
    lh      v0, 0x0020(s0)      #v0 = Pressed buttons
    andi    t6, v0, 0x0010      #t6 = 0 if R isn't pressed
    andi    t7, v0, 0x2000      #t7 = 0 if Z isn't pressed
    
.org 0x803F8ED0
    NOP
    
.org 0x803F8EE0
    addiu   v0, $zero, 0x0003       #v0 = 0x3 (Used $at 0x803F8EF4 when going to copy menu)
    beq     t6, $zero, 0x803F8F08   #Branch if you didn't press R
    lui     $at, 0x0001
    
.org 0x803F8F08
    beq     t7, $zero, 0x803F8FCC   #No buttons pressed, branch

#------------------------------
#Name Select
#------------------------------

.org 0x803F4E10
    addiu   t7, $zero, 0xFFE8   #Make it so that Name Select File Name X offset always is 0xFFE8
    
.org 0x803F4DAC
    addiu   t8, $zero, 0xFFE8   #Make it so that Name Select File Name X offset always is 0xFFE8
    
.org 0x803F4E6C
    addiu   v1, $zero, 0x0049   #Make it so that Name Select File Name Y offset always is 0x0049

.org 0x803F45D8
    addiu   s1, $zero, 0x0030   #Name Select Letters Y Offset

.org 0x803F45F8
    addiu   t0, $zero, 0xFF9F   #Name Select Letters X Offset
    
.org 0x803F467C
    addiu   t0, t0, 0x000F  #Name Select Letters Horizontal Margin

.org 0x803F4870
    addiu   s1, s1, 0xFFEE  #Name Select Letter Vertical Margin

.org 0x803F4DE4
    addiu   v1, v1, 0x000C  #Name Select File Name Letter Width
.org 0x803F4EAC
    addiu   v1, v1, 0xFFF3  #Name Select File Name Letter Height
.org 0x803F5144
    sw      $zero, 0x0004(v0)   #Hide Name Select File Name Panel

#First 7 columns take you to Mode, the others take you to create
#down
.org 0x803F6B5C
    slti    $at, v0, 0x0000 #Never go to the top, always to a button
.org 0x803F6B88
    slti    $at, v0, 0x0000 #Never go to the 1st hidden button
.org 0x803F6BA8
    slti    $at, v0, 0x0000 #Never go to the 2nd hidden button
.org 0x803F6BC8
    slti    $at, v0, 0x0000 #Never go to the 3rd hidden button
#up
.org 0x803F6978
    slti    $at, t6, 0x0000 #Never go to the bottom, always to a button
.org 0x803F69D0
    slti    $at, v0, 0x0007 #Go to the Mode button if on column 0-6

#_____________________________________________________________
#Create Hero Mode Files
#This will make it so that the game creates a normal/hero mode
#file depending on what you chose during name select rather
#than always making file 1 a hero mode file.
#_____________________________________________________________

#include "mips.h"

.set        noreorder
.set        noat

.text

.org 0x800A928C     
    lh      t6, 0x4A48(s1)      #Get file type to create
    
.org 0x800A9294
    bne     t6, $zero, 0x800A92AC   #Branch if file type isn't 0
    
.org 0x800A9354
    NOP                         #Removes command that clear Disk flag on file creation
    
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------
Tables [TBL]
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------

#_____________________________________________________________
#New File Select Screen Layout
#_____________________________________________________________

#File Container Texture Width
0x803FFDB0,0028 0028 0028 0028 0028
#File Container Texture Offsets
0x803FFF54,01016380 01017000 01017C80 01018900 01019580

#0x801C690C

#Menu Colors: Default, Erase, Copy, Normal, Hero
0x803FFDBC,FFFFFF FF8060 FFFFC0 6060FF 646464
#File Y offsets in main menu when selected
0x80400070,0000 0028 0050
#File Y offsets in Erase/Copy menu
0x803FFAE0,0000 0000 0000
#File Y offsets in Erase menu when selected
0x803FFB0C,0000 0028 0050
#File Y offsets in Copy menu when file 1 is selected
0x803FFAEC,0000 0000 0000
#File Y offsets in Copy menu when file 2 is selected
0x803FFAF2,FFD8 0028 0000
#File Y offsets in Copy menu when file 3 is selected
0x803FFAF8,FFD8 FFD8 0050
#File Y offsets in Copy menu when it is the file to copy to
0x803FFB04,FFD8 0000 0028

#Name Select Title Position & Size
0x803FF210,FFE3FFD1
0x803FF220,001BFFD1
0x803FF230,FFE3FFC1
0x803FF240,001BFFC1
#Backspace button position and size
0x803FF310,FF9BFFD1
0x803FF320,FFDBFFD1
0x803FF328,0800
0x803FF330,FF9BFFC1
0x803FF340,FFDBFFC1
0x803FF348,0800
#END button position and size
0x803FF350,0023FFD1
0x803FF360,0063FFD1
0x803FF368,0800
0x803FF370,0023FFC1
0x803FF380,0063FFC1
0x803FF388,0800
#Backspace and END button texture
0x803FFC30,0103C200 0103CA00
#Backspace and END button texture width
0x803FFC48,00400040

#_____________________________________________________________
#Setup default file data
#_____________________________________________________________

#Change files to use new equipment system. Change default health, rupees and items on debug file.
#Regular File (Change health to 6 hearts)
0x00BA16AA,00600060
0x00BA16EC,00000000
0x00BA1718,00000000
0x00BA171C,00500000
#Debug File (Change health to 16 hearts, change rupees to 1000, change default equipped items, have lowest upgrade level of all upgrades, except wallet which has the second)
0x00BA1766,01000100
0x00BA176C,03E8
0x00BA17A0,3B060200 06020000
0x00BA17A8,00000000
0x00BA17D4,00000000
0x00BA17D8,55555655
#Set Debug File to Hero Mode File Type
0x00BA1764,01